/**
 * @file Matrix.h
 * @brief sNX`wb_
 * @author cherub
 * @date 2005.09.16
 */

#ifndef MK_MATRIX_GSL_HEADER_
#define MK_MATRIX_GSL_HEADER_
#pragma once

#include <gsl/gsl_matrix.h>
#include "Vector.h"

/*!
 * @class CMatrixNX Matrix.h
 * @brief GSLs֐Q̃bp[NX
 * @author cherub
 * @date 2005.09.16
 */
class CMatrix
{
public:
	// ftHgRXgN^
	CMatrix(void);
	// TCYwRXgN^
	CMatrix(size_t unRow, size_t unCol);
	// qTCYwRXgN^
	CMatrix(size_t unRow, size_t unCol, double dInit);
	// Rs[RXgN^
	CMatrix(const CMatrix &m);
	// fXgN^
	~CMatrix(void);

public:
	// ֐
	CMatrix& Initialize(size_t unRow, size_t unCol, double dInit =0.0);
	// s̃[NA
	CMatrix& ZeroClear(void);
	// CӒlɂsNA
	CMatrix& Clear(double dInit);
	// IuWFNg̔j
	void Destroy(void);

public:
	//! s̎擾
	size_t RowSize(void) const
		{
			return m_pmMatrix->size1;
		}
	//! 񐔂̎擾
	size_t ColSize(void) const
		{
			return m_pmMatrix->size2;
		}
	//! f[^ANZX֐
	double& Data(size_t r, size_t c)
		{
			return *gsl_matrix_ptr(m_pmMatrix, r, c);
		}
	//! f[^ANZX֐(const)
	const double& Data(size_t r, size_t c) const
		{
			return *gsl_matrix_const_ptr(m_pmMatrix, r, c);
		}
	//! f[^ANZXZq
	double& operator () (size_t r, size_t c)
		{
			return Data(r, c);
		}
	//! f[^ANZXZq(const)
	const double& operator () (size_t r, size_t c) const
		{
			return Data(r, c);
		}
	// sxNg̎擾
	CVector RowVector(size_t r) const;
	// xNg̎擾
	CVector ColVector(size_t c) const;

public:
	// Zq
	CMatrix& CMatrix::operator = (const CMatrix &m);
	// s̈v
	bool operator == (const CMatrix &m) const;
	//! s̕sv
	bool operator != (const CMatrix &m) const
		{
			return !(*this == m);
		}
	// s̑Svf̕𔽓]
	// CMatrix operator - () const; // sv
	// ZZq
	CMatrix operator + (const CMatrix &m) const;
	// ZZq
	CMatrix operator - (const CMatrix &m) const;
	// ZZq
	CMatrix operator * (const CMatrix &m) const;
	// XJZZq
	CMatrix operator + (double d) const;
	// XJZ
	CMatrix operator * (double d) const;

	// ZZq
	CMatrix& operator += (const CMatrix &m);
	// ZZq
	CMatrix& operator -= (const CMatrix &m);
	// ZZq
	CMatrix& operator *= (const CMatrix &m);
	// XJZZq
	CMatrix& operator += (double d);
	// XJZZq
	CMatrix& operator *= (double d);

	// xNgƂ̏ZZq
	CVector operator * (const CVector &v) const;

public:
	// n̒Pʍs𐶐
	CMatrix& LoadIdentity(size_t n);
	// ]us̎擾
	CMatrix Transpose(void) const;
	// LUoR̋tsvZ(ŝ)
	CMatrix InverseLUD(void) const;
	// ْloR̋[tsvZ
	CMatrix InverseSVD(double dThreshold =1.0e-6) const;
	// [ts
	CMatrix PseudoInverse(void) const;
	// (A^+)(A)𖞂[tšvZ
	CMatrix PseudoInverseLeft(void) const;
	// (A)(A^+)𖞂[tšvZ
	CMatrix PseudoInverseRight(void) const;
	// LUoR̍s񎮂̌vZ
	double Determinant(void) const;
	// s̑Ίpvf̘a
	double Trace(void) const;

public:
	// ŏl̎擾
	double MinElement(void) const;
	// ől̎擾
	double MaxElement(void) const;
	// ŏlEől̎擾
	void MinMaxElement(double &dMin, double &dMax) const;
	// ŏlCfNX̎擾
	void MinIndex(size_t &r, size_t &c) const;
	// őlCfNX̎擾
	void MaxIndex(size_t &r, size_t &c) const;
	// ŏlEőlCfNX̎擾
	void MinMaxIndex(size_t &min_r, size_t &min_c, size_t &max_r, size_t &max_c) const;


	//! s񂪎gp\`FbN
	bool IsActive(void)
		{
			return (m_pmMatrix != NULL);
		}

public:
	//! GSLsIuWFNg
	gsl_matrix *m_pmMatrix;
};

#endif //MK_MATRIX_GSL_HEADER_
